%------------------------------------------------------------------------------
% File     : NUM676^1 : TPTP v7.4.0. Released v3.7.0.
% Domain   : Number Theory
% Problem  : Landau theorem 19g
% Version  : Especial.
% English  : more (pl x z) (pl y u)

% Refs     : [Lan30] Landau (1930), Grundlagen der Analysis
%          : [vBJ79] van Benthem Jutting (1979), Checking Landau's "Grundla
%          : [Bro09] Brown (2009), Email to Geoff Sutcliffe
% Source   : [Bro09]
% Names    : satz19g [Lan30]
%          : satz19j [Lan30]
%          : satz32g [Lan30]

% Status   : Theorem
%          : Without extensionality : Theorem
% Rating   : 0.00 v6.0.0, 0.14 v5.5.0, 0.17 v5.4.0, 0.20 v4.1.0, 0.00 v4.0.0, 0.33 v3.7.0
% Syntax   : Number of formulae    :   11 (   0 unit;   7 type;   0 defn)
%            Number of atoms       :   23 (   1 equality;   6 variable)
%            Maximal formula depth :    9 (   3 average)
%            Number of connectives :   17 (   0   ~;   0   |;   0   &;  16   @)
%                                         (   0 <=>;   1  =>;   0  <=;   0 <~>)
%                                         (   0  ~|;   0  ~&)
%            Number of type conns  :    4 (   4   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :    9 (   7   :;   0   =)
%            Number of variables   :    3 (   0 sgn;   3   !;   0   ?;   0   ^)
%                                         (   3   :;   0  !>;   0  ?*)
%                                         (   0  @-;   0  @+)
% SPC      : TH0_THM_EQU_NAR

% Comments : 
%------------------------------------------------------------------------------
thf(nat_type,type,(
    nat: $tType )).

thf(x,type,(
    x: nat )).

thf(y,type,(
    y: nat )).

thf(z,type,(
    z: nat )).

thf(u,type,(
    u: nat )).

thf(i,axiom,(
    x = y )).

thf(more,type,(
    more: nat > nat > $o )).

thf(m,axiom,
    ( more @ z @ u )).

thf(pl,type,(
    pl: nat > nat > nat )).

thf(satz19d,axiom,(
    ! [Xx: nat,Xy: nat,Xz: nat] :
      ( ( more @ Xx @ Xy )
     => ( more @ ( pl @ Xz @ Xx ) @ ( pl @ Xz @ Xy ) ) ) )).

thf(satz19g,conjecture,
    ( more @ ( pl @ x @ z ) @ ( pl @ y @ u ) )).

%------------------------------------------------------------------------------
